/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_clshift ( result, overflow,
        underflow, data,
        direction, distance) ;

  parameter lpm_type        = "lpm_clshift" ;
  parameter lpm_width       = 2 ;
  parameter lpm_widthdist   = 1 ;
  parameter lpm_shifttype   = "LOGICAL" ;
  parameter polar_data      = "NORMAL" ;
  parameter polar_distance  = "NORMAL" ;
  parameter polar_direction = "NORMAL" ;
  parameter polar_result    = "NORMAL" ;
  parameter polar_overflow  = "NORMAL" ;
  parameter polar_underflow = "NORMAL" ;

  input  [lpm_width-1:0] data ;
  input  [lpm_widthdist-1:0] distance ;
  input  direction ;
  output [lpm_width-1:0] result;
  output overflow ;
  output underflow;


  // inernal reg
  reg   [lpm_width-1:0] tmp_result ;
  reg   [lpm_width-1:0] pdata ;
  reg   [lpm_widthdist-1:0] pdistance ;
  reg   pdirection ;
  reg   [lpm_width-1:0] ONES, UNKNOWN ;
  reg   ovfl, udfl ;
  integer i ;


  pulldown P1 ( direction) ;

//---------------------------------------------------------------//
  function [lpm_width+1:0] LogicShift ;
    input [lpm_width-1:0] data ;
    input [lpm_widthdist-1:0] dist ;
    input direction ;
    reg   [lpm_width-1:0] tmp_buf ;
	reg   ovfl, udfl ;
	
    begin
	  tmp_buf = data ;
	  ovfl = 1'b0 ;
	  udfl = 1'b0 ;
	  if((direction) && (dist > 0))	// shift right
		begin
			tmp_buf = data >> dist ;
			if((data != 0 ) && ((dist >= lpm_width) || (tmp_buf == 0) ))
				udfl = 1'b1;
		end
	  else if (dist > 0) // shift left
		begin
			tmp_buf = data << dist ;
			if((data != 0) && ((dist >= lpm_width)
				|| ((data >> (lpm_width-dist)) !== 0)))
				ovfl = 1'b1;
		end
	  LogicShift = {ovfl,udfl,tmp_buf[lpm_width-1:0]} ;
    end
  endfunction

//---------------------------------------------------------------//
  function [lpm_width+1:0] ArithShift ;
    input [lpm_width-1:0] data ;
    input [lpm_widthdist-1:0] dist ;
    input direction ;
    reg   [lpm_width-1:0] tmp_buf ;
	reg   ovfl, udfl ;
    begin
	  tmp_buf = data ;
	  ovfl = 1'b0 ;
	  udfl = 1'b0 ;

	  if(direction && (dist > 0))	// shift right
		begin
			if(data[lpm_width-1] == 0) // positive number
			  begin
	  			tmp_buf = data >> dist ;
				if((data != 0) && ((dist >= lpm_width) || (tmp_buf === 0)))
					udfl = 1'b1 ;
			  end
			else // negative number
			  begin
	  			tmp_buf = (data >> dist) | (ONES << (lpm_width - dist)) ;
				if((data !== ONES) && ((dist >= lpm_width-1) || (tmp_buf === ONES)))
					udfl = 1'b1 ;
			  end
		end
	  else if(dist > 0) // shift left
		begin
			tmp_buf = data << dist ;
			if(data[lpm_width-1] == 0) // positive number
			  begin
				if((data != 0) && ((dist >= lpm_width-1) 
				|| ((data >> (lpm_width-dist-1)) !== 0)))
					ovfl = 1'b1;
			  end
			else // negative number
			  begin
				if((data !== ONES) 
				&& ((dist >= lpm_width) 
				 ||(((data >> (lpm_width-dist-1))|(ONES << (dist+1))) !== ONES)))
					ovfl = 1'b1;
			  end
		end
	  ArithShift = {ovfl,udfl,tmp_buf[lpm_width-1:0]} ;
    end
  endfunction

//---------------------------------------------------------------//
  function [lpm_width-1:0] RotateShift ;
    input [lpm_width-1:0] data ;
    input [lpm_widthdist-1:0] dist ;
    input direction ;
    reg   [lpm_width-1:0] tmp_buf ;
    begin
	  tmp_buf = data ;
	  if((direction) && (dist > 0))	// shift right
		begin
			tmp_buf = (data >> dist) | (data << (lpm_width - dist)) ;
		end
	  else if (dist > 0) // shift left
		begin
			tmp_buf = (data << dist) | (data >> (lpm_width - dist)) ;
		end
	  RotateShift = tmp_buf[lpm_width-1:0] ;
    end
  endfunction
//---------------------------------------------------------------//
  initial
  begin
	// check for valid lpm_width's value.
	if(lpm_width <= 1)
	  begin
	  	$display("%d: Error: lpm_width must be greater than 1.", $time);
		$stop;
	  end
	
	// initialize constant registers
    for(i=0; i < lpm_width; i=i+1)
	  begin
        ONES[i] = 1'b1 ;
        UNKNOWN[i] = 1'bx ;
	  end
  end

  always @( direction )
  begin
    pdirection <= #1 (polar_direction == "INVERT")?~direction:direction;
  end

  always @( data or distance )
  begin
    pdata      <= #1 (polar_data == "INVERT")?~data:data;
    pdistance  <= #1 (polar_distance == "INVERT")?~distance:distance;
  end

  always @(pdata or pdirection or pdistance)
    begin
	  ovfl = 1'b0 ;
	  udfl = 1'b0 ;
	  // lpm_shifttype is optional and default to LOGICAL
      if ((lpm_shifttype == "LOGICAL") || (lpm_shifttype == ""))
        begin
		  {ovfl,udfl,tmp_result} = LogicShift(pdata,pdistance,pdirection);
        end
      else if (lpm_shifttype == "ARITHMETIC")
        begin
		  {ovfl,udfl,tmp_result} = ArithShift(pdata,pdistance,pdirection);
        end
      else if (lpm_shifttype == "ROTATE")
        begin
		  tmp_result = RotateShift(pdata, pdistance, pdirection) ;
        end
      else
        begin
		  tmp_result = UNKNOWN ;
        end
	end

  assign result = (polar_result == "INVERT")? ~tmp_result:tmp_result ;
  assign overflow  =  (polar_overflow == "INVERT")? ~ovfl:ovfl ;
  assign underflow =  (polar_underflow == "INVERT")? ~udfl:udfl ;

 endmodule // lpm_clshift
`ifdef SYNTH
`else
`endcelldefine
`endif

